/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oip.oipc.oipch;

import java.io.IOException;
import java.io.PrintWriter;
import oracle.sysman.oii.oiix.OiixPlatform;
import oracle.sysman.oip.oipc.oipch.OipchAIXOSWriter;
import oracle.sysman.oip.oipc.oipch.OipchDECOSWriter;
import oracle.sysman.oip.oipc.oipch.OipchHPOSWriter;
import oracle.sysman.oip.oipc.oipch.OipchLinuxOSWriter;
import oracle.sysman.oip.oipc.oipch.OipchOS;
import oracle.sysman.oip.oipc.oipch.OipchSolarisOSWriter;
import oracle.sysman.oip.oipc.oipch.OipchVendor;
import oracle.sysman.oip.oipc.oipch.OipchVersion;
import oracle.sysman.oip.oipc.oipch.OipchWindowsOSWriter;
import oracle.xml.parser.v2.XMLElement;
import org.w3c.dom.Node;

public abstract class OipchOSWriter {
    static OipchOSWriter getWriter() {
        OipchOSWriter oOSWriter = null;
        switch (OiixPlatform.getCurrentPlatform()) {
            case 453: {
                oOSWriter = new OipchSolarisOSWriter();
                break;
            }
            case 46: 
            case 110: 
            case 211: {
                oOSWriter = new OipchLinuxOSWriter();
                break;
            }
            case 2: 
            case 197: {
                oOSWriter = new OipchHPOSWriter();
                break;
            }
            case 208: 
            case 233: 
            case 912: {
                oOSWriter = new OipchWindowsOSWriter();
                break;
            }
            case 610: {
                oOSWriter = new OipchAIXOSWriter();
                break;
            }
            case 87: {
                oOSWriter = new OipchDECOSWriter();
            }
        }
        return oOSWriter;
    }

    int save(OipchOS oOS, PrintWriter pWriter) throws IOException {
        XMLElement xmlOSystem = new XMLElement("OPERATING_SYSTEM");
        xmlOSystem.appendChild((Node)this.getArch(oOS.getOSName()));
        xmlOSystem.appendChild((Node)this.getName(oOS.getOSArch()));
        xmlOSystem.appendChild((Node)this.getVersion(oOS.getOSVersion()));
        xmlOSystem.appendChild((Node)this.getVendor(oOS.getOSVendor()));
        this.appendOSSpecInfo(oOS, xmlOSystem);
        xmlOSystem.print(pWriter);
        return 0;
    }

    protected abstract void appendOSSpecInfo(OipchOS var1, XMLElement var2);

    private XMLElement getVendor(OipchVendor oVendor) {
        XMLElement xmlNode = null;
        if (oVendor != null) {
            xmlNode = new XMLElement("VENDOR");
            xmlNode.setAttribute("VALUE", oVendor.getVendor());
        }
        return xmlNode;
    }

    private XMLElement getVersion(OipchVersion oVer) {
        XMLElement xmlNode = null;
        if (oVer != null) {
            xmlNode = new XMLElement("VERSION");
            xmlNode.setAttribute("VALUE", oVer.getVersion());
        }
        return xmlNode;
    }

    private XMLElement getArch(String sVal) {
        XMLElement xmlNode = new XMLElement("ARCHITECTURE");
        xmlNode.setAttribute("VALUE", sVal);
        return xmlNode;
    }

    private XMLElement getName(String sVal) {
        XMLElement xmlNode = new XMLElement("NAME");
        xmlNode.setAttribute("VALUE", sVal);
        return xmlNode;
    }
}

